﻿if ($.mobile) {
    $(document).on("pageinit", function () {
        initializeLookupTables();
    });
}
else {
    $(document).ready(function () {
        initializeLookupTables();
    });
}

function initializeLookupTables() {
    $(".h-questionTable").each(function () {
        var tableId = $(this).attr("data-tableId");
        var dataColumns = JSON.parse($(this).attr("data-columns"));
        var displaySearch = _.some(dataColumns, function (c) { return c.Searchable; });
        var filter = $(this).attr("data-filter");
        var sortDirection = $(this).attr("data-sortDirection");
        var sortIndex = Math.max(0, _.indexOf(_.pluck(dataColumns, "Data"), $(this).attr("data-sortColumn"))) + 1;
        var searchColumns = $(this).attr("data-searchColumns");
        var showAdvanceFilters = $(this).attr("data-advanced-filters") == "true";
        var maxAnswerVal = $(this).attr("data-maxAllowed") != "" ? parseInt($(this).attr("data-maxAllowed"), 10) : 100;
        var pageSize = parseInt($(this).attr("data-pageSize"));
        var hasSelection = $("input[data-keys]", $(this).closest(".questionContent")).val() != "";

        var dataUrl = (typeof se != 'undefined') ? $("#SEURL").val() + "Eval.aspx/GetLookupTableData" : a4.getAction("GetLookupTablePreview", "Questionnaire", "Survey");

        if (tableId && dataColumns) {
            var table = $("table", $(this));
            
            table.sedatatable({
                generateTableStructure: false,
                ajaxAction: dataUrl,
                ajaxParams: { "tableId": tableId, "filter": filter, "searchColumns": searchColumns },
                defaultSorting: [[sortIndex, sortDirection]],
                columns: dataColumns,
                displayLength: pageSize,
                displaySearchBox: displaySearch,
                advancedFilter: showAdvanceFilters,
                allowRowSelection: true,
                rememberRowSelection: true,
                limitRowSelection: maxAnswerVal,
                displayContextMenu: false,
                customStyle: 'ui-responsive',
                quickFilter: !hasSelection ? null
                    : {
                        "AlwaysVisible": true,
                        "IncludeSelectedStates": true,
                        "Items": []
                    },
                draw: function () {
                    if ($.mobile) {
                        $("table.ui-responsive", table).table();
                    }

                    $("thead tr th", table).addClass("lookupTableColumnHeader");
                    $("tbody tr.odd td", table).addClass("lookupTableAlternateRow");
                    $("tbody tr.even td", table).addClass("lookupTableRow");
                    $("td, th", table).addClass("lookupTableItem");
                }
            });

            if (hasSelection) {
                $(this).find(".filter-bar .selected").trigger("click");
            }

            $(this).on("mouseover", "tbody tr", function () {
                $(this).find("td").addClass("lookupTableHighlightedAxis");
            })
                .on("mouseleave", "tbody tr", function () {
                    $(this).find("td").removeClass("lookupTableHighlightedAxis");
                });

            $(this).on("change", ".selectRow", function () {
                $(this).closest("tr").find("td").toggleClass("lookupTableSelectedAxis", $(this).is(':checked'));
            });

            $(this).on("change", ".h-selectAll", function () {
                $(this).closest("tbody").find("td").toggleClass("lookupTableSelectedAxis", $(this).is(':checked'));
            });
        }
    });
}